unit TSPcode;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Edit1: TEdit;
    Button2: TButton;
    Button3: TButton;
    Button4: TButton;
    Button5: TButton;
    Button6: TButton;
    Button7: TButton;
    Button8: TButton;
    Button9: TButton;
    Edit2: TEdit;
    Edit3: TEdit;
    procedure FormMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure FormCreate(Sender: TObject);
    procedure FormPaint(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Speichern(i,anz:integer; offset:longint);
    procedure Printperm(anz:integer;offset:longint;dist:real);
    procedure Edit1Change(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure Button6Click(Sender: TObject);
    procedure Button7Click(Sender: TObject);
    procedure Button8Click(Sender: TObject);
    procedure Button9Click(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    { Private-Deklarationen }
  public
    procedure StartIt;
    { Public-Deklarationen }
  end;

mythread=class(TThread)
protected
  procedure Execute; override;
end;

zmytree=^mytree;
mytree=record
  ax,bx,ay,by:longint;
  next:zmytree;
  end;

var
  Form1: TForm1;
  xvals,yvals,best: array [1..20] of integer;
  pnum,mdelay,xoff,yoff,scale: integer;
  matrix: array [1..20,1..20] of real;
  weg: array[1..20] of integer; {0-> im Topf 1-> nicht im Topf}
  list: array[1..20]of integer;
  min,strtotmin:real;
  strmin:array[1..20] of real;
  sf,count:longint;
  paintdepth:integer; {Boeses Foul}
  thethread:mythread;
  thetree:zmytree;
  running:boolean;

implementation

{$R *.dfm}


function MyPower(a,b:integer):longint;
var i:integer;
    k:longint;

begin;
  k:=1;
  for i:=1 to b do k:=k*a;
  MyPower:=k;
end;


procedure TForm1.FormMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
if (x<400) and (y<400) and (not running) then
  begin
    if (pnum<20)then
    begin
    pnum:=pnum+1;
    xvals[pnum]:=x;
    yvals[pnum]:=y;
    canvas.Brush.color:=clBlack;
    canvas.Ellipse(X-3,Y-3,x+3,y+3);
    end
  end
  else
  begin
  end
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
pnum:=0;
min:=100000;
mdelay:=1000;
New(thetree);
thetree^.next:=NIL;
xoff:=600;
yoff:=150;
scale:=0;
sf:=1;
DoubleBuffered:=true;
count:=0;
end;

procedure TForm1.FormPaint(Sender: TObject);
var i:integer;
    it:zmytree;
    MyRgn:HRGN;

begin

  MyRgn := CreateRectRgn(0,0,401,401);
    SelectClipRgn(Canvas.Handle,MyRgn);

  canvas.pen.width:=1;
  canvas.MoveTo(400,0);
  canvas.LineTo(400,400);
  canvas.LineTo(0,400);
  Canvas.Brush.Color:=clBlack;
  canvas.pen.color:=clBlack;
  for i:=1 to pnum  do
  begin
   canvas.Ellipse(xvals[i]-3,yvals[i]-3,xvals[i]+3,yvals[i]+3);
  end;
  if min < 1000000 then
  begin
    canvas.pen.color:=clRed;
    canvas.pen.width:=4;
    canvas.MoveTo(xvals[1],yvals[1]);
    begin
      for i:=1 to pnum  do
      canvas.Lineto(xvals[best[i]],yvals[best[i]]);
    end;
    canvas.lineto(xvals[1],yvals[1]);
  end;
  canvas.pen.width:=2;
  if (paintdepth > 1) and (running) then
  begin
    canvas.pen.color:=clBlack;
    canvas.MoveTo(xvals[1],yvals[1]);
    for i:=2 to paintdepth do
    begin
      canvas.Lineto(xvals[list[i]],yvals[list[i]]);
    end;
  end;
  DeleteObject(MyRgn);
  MyRgn := CreateRectRgn(400,0,800,800);
  SelectClipRgn(Canvas.Handle,MyRgn);

  canvas.pen.color:=clBlack;
  canvas.pen.width:=1;
  it:=thetree;
  if pnum  < 10 then
  while it.next<>NIL do
  begin
    canvas.Moveto(it^.ax div sf+xoff,it^.ay +yoff);
    canvas.LineTo(it^.bx div sf+xoff,it^.by +yoff);
    it:=it^.next;
  end;
  SelectClipRgn(Canvas.Handle,HRGN(nil));
  DeleteObject(MyRgn);

end;

procedure TForm1.Button1Click(Sender: TObject);
var i,j:integer;
    pm,sm:real;
begin
  for i:=1 to pnum do
   begin
    pm:=1000000;
    sm:=1000000;
    for j:=1 to pnum do
    begin
       matrix[i,j]:=sqrt(((xvals[i]-xvals[j])* (xvals[i]-xvals[j])+ (yvals[i]-yvals[j])* (yvals[i]-yvals[j])));
       if (matrix[i,j]<sm) then
          begin
            if (matrix[i,j]<pm) then
            begin
              sm:=pm;
              pm:=matrix[i,j];
            end
            else sm:=matrix[i,j];
          end;
    end;
    strmin[i]:=(pm+sm)/2; {Mittel aus krzester und 2. krzester Kante}
    strtotmin:=strtotmin+strmin[i];
  end;
  strtotmin:=strtotmin-strmin[1];
  thethread:=mythread.Create(False);
end;

procedure TForm1.StartIt;
begin
  weg[1]:=1;
  list[1]:=1;
  min:=1000000;
  running:=true;
  Printperm(1,0,0);
  running:=false;
  Repaint;
end;

procedure TForm1.Speichern(i,anz:integer; offset:longint);

var ast:zmytree;
    help:longint;

begin
        paintdepth:=anz+1;
        new(ast);
        ast^.ax:=offset;
        ast^.ay:=trunc((20*anz));
        help:=2*longint(MyPower(pnum,(pnum-anz-1)));
        ast^.bx:= offset+i*help -(pnum*help div 2);
        ast^.by:=trunc((20*(anz+1)));
        ast^.next:=thetree;
        thetree:=ast;
        Repaint;
        sleep(mdelay);
end;


procedure TForm1.Printperm(anz: integer;offset: longint;dist: real);

var i:integer;


begin
  if anz=pnum then {a Elemente rausgenommen = Topf leer }
  begin
    dist:=dist+matrix[list[anz],1];
    count:=count+1;
    Edit2.Text:=IntToStr(count);
    if (dist < min) then
    begin
    min:=dist;
    Edit3.Text:=FloatToStr(min);
    for i:=1 to  pnum
      do
      begin;
        best[i]:=list[i];
      end;
    end;
  end
  else
  begin
    for i:=1 to pnum do
    begin
      if ((weg[i] <> 1) and running
      and (dist +strtotmin < min) and (dist+matrix[list[anz],1]< min)) then
      begin
        weg[i] :=1; {nimm raus}
        list[anz+1]:=i; {schreib auf Zettel /Tafel}
        strtotmin:=strtotmin - strmin[i]; {minimale Reststrecke durch die
        uebrigen Knoten}
        Speichern(i,anz,offset);
        Printperm(anz+1,thetree^.bx,dist+matrix[list[anz],list[anz+1]]);
        Repaint;
        sleep(mdelay);
        weg[i]:=0; {leg wieder rein}
        strtotmin:=strtotmin+strmin[i];
      end
    end
  end;
end;

procedure mythread.Execute;
begin
      Form1.StartIt;

end;

procedure TForm1.Edit1Change(Sender: TObject);
begin
  if not TryStrToInt(Edit1.Text,mdelay) then mdelay:=0;
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
if thethread <> NIL then
if thethread.Suspended
then thethread.Resume
else thethread.Suspend;
end;

procedure TForm1.FormDestroy(Sender: TObject);
var it:zmytree;
begin
running:=false;
thethread.Free;
while thetree <> nil do
begin
  it:=thetree.next;
  Dispose(thetree);
  thetree:=it;
end;
end;

procedure TForm1.Button4Click(Sender: TObject);
begin
xoff:=xoff+40;
Repaint;
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
xoff:=xoff-40;
Repaint;
end;

procedure TForm1.Button6Click(Sender: TObject);
begin
         yoff:=yoff+40;
         Repaint;
end;

procedure TForm1.Button5Click(Sender: TObject);
begin
 yoff:=yoff-40;
 Repaint;
end;

procedure TForm1.Button8Click(Sender: TObject);
begin
 scale:=scale+1;
 xoff:=600-((600-xoff)) div 2;
 sf:=MyPower(2,scale);
 Repaint;
end;

procedure TForm1.Button7Click(Sender: TObject);
begin
  if scale > 0 then
  begin
    scale:=scale-1;
    xoff:=600-((600-xoff)) * 2;
  end;
  sf:=MyPower(2,scale);
  Repaint;
end;

procedure TForm1.Button9Click(Sender: TObject);
begin
xoff:=600;
yoff:=100;
scale:=0;
sf:=1;
Repaint;
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
mdelay:=0;
running:=false;
if thethread <> nil then thethread.Resume;
end;


end.
