/*
 * Decompiled with CFR 0.152.
 */
package com.puravidaapps;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.hardware.Camera;
import android.util.Log;
import com.google.appinventor.components.annotations.DesignerComponent;
import com.google.appinventor.components.annotations.PropertyCategory;
import com.google.appinventor.components.annotations.SimpleFunction;
import com.google.appinventor.components.annotations.SimpleObject;
import com.google.appinventor.components.annotations.SimpleProperty;
import com.google.appinventor.components.annotations.UsesPermissions;
import com.google.appinventor.components.common.ComponentCategory;
import com.google.appinventor.components.runtime.AndroidNonvisibleComponent;
import com.google.appinventor.components.runtime.Component;
import com.google.appinventor.components.runtime.ComponentContainer;

@DesignerComponent(version=1, description="Extension to turn on/off the flashlight.Version 1a as of 2016-08-11 for App Inventor version nb150 and Companion version 2.38.", category=ComponentCategory.EXTENSION, nonVisible=true, iconName="https://puravidaapps.com/images/taifun16.png")
@SimpleObject(external=true)
@UsesPermissions(permissionNames="android.permission.CAMERA, android.permission.FLASHLIGHT")
public class TaifunFlashlight
extends AndroidNonvisibleComponent
implements Component {
    public static final int VERSION = 1;
    private ComponentContainer container;
    private Context context;
    private static final String LOG_TAG = "TaifunFlashlight";
    private static Camera camera = null;
    private boolean hasFlash = false;
    private boolean isFlashOn = false;

    public TaifunFlashlight(ComponentContainer container) {
        super(container.$form());
        this.container = container;
        this.context = container.$context();
        Log.d((String)LOG_TAG, (String)"TaifunFlashlight Created");
        this.hasFlash = this.context.getPackageManager().hasSystemFeature("android.hardware.camera.flash");
    }

    @SimpleProperty(category=PropertyCategory.BEHAVIOR, description="whether the device has flash")
    public boolean HasFlash() {
        return this.hasFlash;
    }

    @SimpleFunction(description="turn on the flashlight.")
    public void On() {
        Log.d((String)LOG_TAG, (String)("On, camera flash feature: " + this.hasFlash));
        try {
            if (this.hasFlash && !this.isFlashOn) {
                camera = Camera.open();
                Camera.Parameters p = camera.getParameters();
                p.setFlashMode("torch");
                camera.setParameters(p);
                SurfaceTexture mPreviewTexture = new SurfaceTexture(0);
                camera.setPreviewTexture(mPreviewTexture);
                camera.startPreview();
                this.isFlashOn = true;
            }
        }
        catch (Exception e) {
            Log.e((String)LOG_TAG, (String)e.getMessage(), (Throwable)e);
            e.printStackTrace();
        }
    }

    @SimpleFunction(description="turn off the flashlight.")
    public void Off() {
        Log.d((String)LOG_TAG, (String)("Off, camera flash feature: " + this.hasFlash));
        try {
            if (this.isFlashOn) {
                camera.stopPreview();
                camera.release();
                camera = null;
                this.isFlashOn = false;
            }
        }
        catch (Exception e) {
            Log.e((String)LOG_TAG, (String)e.getMessage(), (Throwable)e);
            e.printStackTrace();
        }
    }
}

